using System;
using Server.Items;
using System.Collections;
using System.Collections.Generic;
using Server.Spells;
using Server.Engines.CannedEvil;

namespace Server.Mobiles
{
	public class Morax : BaseChampion
	{
		public override bool ClickTitle { get { return false; } }
		public override bool AlwaysAttackable { get { return true; } }
		public override bool CanRummageCorpses { get { return true; } }
		public override bool BardImmune { get { return true; } }
		public override bool Unprovokable { get { return true; } }
		public override bool Uncalmable { get { return true; } }
		public override Poison PoisonImmune { get { return Poison.Lethal; } }
		public override int TreasureMapLevel { get { return 5; } }
		public override bool IsNotScaredOfDeath { get { return true; } } //neutika pri malem poctu hp

		public override WeaponAbility GetWeaponAbility()
		{
			return Utility.RandomBool() ? WeaponAbility.ConcussionBlow : WeaponAbility.CrushingBlow;
		}

		private DateTime m_Delay = DateTime.Now;
		private int m_Scavengers = 0;

		public override ChampionSkullType SkullType { get { return ChampionSkullType.Greed; } }

		[Constructable]
		public Morax() : this (false, 3)
		{
		}

		[Constructable]
		public Morax(int range) : this (false, range)
		{
		}

		[Constructable]
		public Morax(bool ischampion, int range) : base(AIType.AI_Melee, FightMode.Closest, ischampion, range)
		{
			Hue = DarkElf.RandomDarkElfSkinHue;
			SpeechHue = Utility.RandomDyedHue();
			EmoteHue = Utility.RandomNeutralHue();

			Body = 605;
			Name = "Morax";
			HairItemID = Race.Elf.RandomHair(Female);
			HairHue = DarkElf.RandomDarkElfHairHue;
			Race = Race.Elf;
			Title = "the Dark";

			DropMin = 30;
			DropMax = 70;
			DropType = ChampDrop.DemonDust;
			BonusLoot = "SlzaAuberonu";
			BonusLootAmount = 1;

			SetStr(700, 720);
			SetDex(1000, 1100);
			SetStr(700, 720);

			SetHits(90000);
			SetMana(2500);
			SetStam(1000);

			SetDamage(25, 23);

			SetDamageType(ResistanceType.Cold, 70);
			SetDamageType(ResistanceType.Poison, 30);

			SetResistance(ResistanceType.Physical, 50, 70);
			SetResistance(ResistanceType.Fire, 50, 70);
			SetResistance(ResistanceType.Cold, 60, 65);
			SetResistance(ResistanceType.Poison, 55, 60);
			SetResistance(ResistanceType.Energy, 50, 65);

			SetSkill(SkillName.EvalInt, 77.6, 110.5);
			SetSkill(SkillName.Necromancy, 190.6, 220.5);
			SetSkill(SkillName.Macing, 130.1, 130.5);
			SetSkill(SkillName.Magery, 150.1, 160.1);
			SetSkill(SkillName.Poisoning, 80.5);
			SetSkill(SkillName.Meditation, 110.0);
			SetSkill(SkillName.MagicResist, 80.1, 85.0);
			SetSkill(SkillName.Parry, 90.1, 100.1);
			SetSkill(SkillName.Tactics, 130.0);
			SetSkill(SkillName.Anatomy, 100.0);
			SetSkill(SkillName.Wrestling, 90.1, 120.0);
			SetSkill(SkillName.Swords, 115.1, 120.0);

			// outfit
			BaseArmor arms = new WoodlandArms();
			arms.Hue = 2475;
			//          arms.Resource = CraftResource.BarbedLeather;
			arms.Movable = false;
			AddItem(arms);

			BaseArmor chest = new WoodlandChest();
			//          chest.Resource = CraftResource.BarbedLeather;
			chest.Hue = 2475;
			chest.Movable = false;
			AddItem(chest);

			BaseArmor gloves = new WoodlandGloves();
			//          gloves.Resource = CraftResource.BarbedLeather;
			gloves.Hue = 2475;
			gloves.Movable = false;
			AddItem(gloves);
			BaseArmor gorget = new WoodlandGorget();
			//          gorget.Resource = CraftResource.BarbedLeather;
			gorget.Hue = 2475;
			gorget.Movable = false;
			AddItem(gorget);
			BaseArmor legs = new WoodlandLegs();
			//          legs.Resource = CraftResource.BarbedLeather;
			legs.Hue = 2475;
			legs.Movable = false;
			AddItem(legs);

			Item cloak = new Cloak();
			cloak.Hue = 2564;
			cloak.ItemID = 11013;
			cloak.Movable = false;
			AddItem(cloak);

			Item belt = new WoodlandBelt(2564);
			belt.Movable = false;
			AddItem(belt);

			Item boots = new ElvenBoots(2564);
			boots.Movable = false;
			AddItem(boots);

			BaseWeapon diamondmace = new DiamondMace();
			diamondmace.Resource = CraftResource.ShadowIron;
			diamondmace.Movable = false;
			diamondmace.Hue = 2564;
			AddItem(diamondmace);

			BaseShield shield = new MetalKiteShield();
			shield.Hue = 2564;
			shield.Movable = false;
			AddItem(shield);

			Fame = 32000;
			Karma = -15000;

			Item reags = Loot.RandomReagent();
			reags.Amount = 500;
			PackItem(reags);

			// 			if ( Utility.RandomDouble() < 0.5 )
			// 				PackItem( new BaseTotemSummoner( (TotemType) Utility.Random( 3 ) ) );
		}

		public override bool OnBeforeDeath()
		{
			if (!base.OnBeforeDeath())
				return false;

			Server.Regions.KhaldunRegion.DropHealthOrb(this);

			Effects.SendLocationEffect(Location, Map, 0x376A, 10, 1);
			return true;
		}

		public override void OnDamage(int amount, Mobile from, bool willKill, int typ)
		{
			base.OnDamage(amount, from, willKill, typ);

			if (from == null)
				return;

			if (m_Scavengers < 4 && Utility.RandomDouble() < 0.01 && this.Hits < (this.HitsMax * 90) / 100)
			{
				BaseCreature scavenger = new WispNecromancer();

				scavenger.IsParagon = true;

				scavenger.Fame = 8000;
				scavenger.MoveToWorld(TavaraSewel.GetSpawnPosition(from.Location, from.Map, 6), from.Map);
				scavenger.Combatant = from;
				m_Scavengers++;
				Server.Regions.KhaldunRegion.DropHealthOrb(this);
			}

			if (Utility.RandomDouble() < 0.01 && from.Player)
			{
				KhalAnkur.Waller(3, 8, from);
			}

			if (DateTime.Now > m_Delay && Utility.RandomDouble() < 0.005 && this.Hits < (this.HitsMax * 80) / 100 && from.Player)
			{
				LysanderGathenwale.SummoningRing(this, typeof(ShadowWisp));
				m_Delay = DateTime.Now + TimeSpan.FromSeconds(Utility.RandomMinMax(20, 30));
			}

			if (Utility.RandomDouble() < 0.015 && this.Hits < (this.HitsMax * 50) / 100)
			{
				Server.Engines.XmlSpawner2.FlareVortex vortex = new Server.Engines.XmlSpawner2.FlareVortex();

				vortex.ItemID = 13900;
				vortex.Hue = 0;
				vortex.Name = "totem";
				vortex.MoveToWorld(TavaraSewel.GetSpawnPosition(from.Location, from.Map, 10), from.Map);
			}

			if(Utility.RandomDouble() < 0.002)
			{
				if(!KhalAnkur.IsUnderInfluence(from))
				{
					KhalAnkur.Silence(from, this);
				}
			}

			if (DateTime.Now > m_Delay && this.Hits < (this.HitsMax * 70) / 100)
			{
				m_Delay = DateTime.Now + TimeSpan.FromSeconds(Utility.RandomMinMax(30, 60));

				Effects.PlaySound(this.Location, this.Map, this.GetAngerSound());
				LysanderGathenwale.SummoningRing(this, typeof(Sewerrat));
				Server.Regions.KhaldunRegion.DropHealthOrb(this);

				ArrayList targets = Utilitky.GetTargets(this, 8, true);

				for (int i = 0; i < targets.Count; ++i)
				{
					Mobile m = (Mobile)targets[i];

					if (m == null || m.Deleted)
						continue;

					m.RevealingAction();
					m.PlaySound(0x50D);
					m.FixedParticles(0x37B9, 1, 5, 0x251D, 0x651, 0, EffectLayer.Waist);

					int auradamage = Engines.XmlSpawner2.XmlSpecial.PercentualDamage(Utility.RandomMinMax(25, 35), m);

					if (m is Xanthos.Interfaces.IEvoCreature)
						auradamage *= 5;

					m.Hits -= auradamage;
					m.Mana /= 2;
					ISTile5.SendDmgPacket(m, auradamage);

					if (m.Hits < 2)
						m.Kill();
				}
			}
		}

		public Morax(Serial serial) : base(serial)
		{
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);

			writer.Write((int) 0); // version
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);

			int version = reader.ReadInt();
		}
	}
}